%% Simulation 
% Make simulation instance:
current_simulation                  = DPP_simulator  % make simulation instance

current_simulation.set_cell(current_cell);

% loggin/visualizatoin
current_simulation.show_log                 = 1;        % 1: output to the command line what parameters are varied.
current_simulation.show_visually            = 0;        % N: show the nucleus and spindle with each N iterations; 0: don't show.

% autosave flags
current_simulation.auto_save_nucleus_run    = 1;        % save the nucleus run after simulation is finished (image)  
current_simulation.auto_save_torque_map     = 1;        % save the torque map (image)
current_simulation.auto_save_state_history  = 1;        % save the state history (image)
current_simulation.auto_save_split_image    = 1;        % save the predicted division plane (image)

% Random Walk parameters
current_simulation.angle_btw_mt_deg         = 10;       % integer, 1/2/3/4   1 = each degree (from 0, 1, 2 ... 360);  2 = each 2 degrees (0, 2, 4 ,... , 360).

current_simulation.jump_chance              = 10;      	% (in %): Probability of jumping out to a new configuration, even if it is less favorable than previous.
                                                        %  10 = 10% chance of juming out.
current_simulation.inertia                  = 80;      	% (in %): Probability to vary the same parameter in the same manner if the previous variation was favorable. 
                                                        % 100 = 100% chance to vary the same parameter all the time; 0 = 0% chance to vary the same parameter (random).
current_simulation.duration_equilibrium     = 600;    	% Number of iterations (with x, y, z, theta and phi not changing) necessary to consider the equilibrium is reachad
current_simulation.duration_full            = 10000;  	% Maximum number of iterations

% torque map parameters
current_simulation.auto_calc_torque_map     = 0;        % if set to 1, torque map is calculated automatically in the end.
current_simulation.torque_map_angle_step    = 10;       % Angular precision of the angular potential calculation and plots (in degrees)          



current_simulation.run



%% Refine division orientation :
current_simulation.reset;                             % resets the counter to 0 and equilibrium flag to 0
current_simulation.angle_btw_mt_deg         = 1;      % set the angle step between MTs to a smaller value to make it more precise
current_simulation.auto_calc_torque_map     = 1;      % (optional) set flag for automatic calculation of the torque map.
current_simulation.duration_full            = 10000;   % (optional) change the "duration_equilibrium/duration_full" parameters.

current_simulation.run;

current_simulation.show_state_history  
current_simulation.show_division_plane

%% Other accessible commandes:
% current_simulation.show_nucleus_run          % show the cell and nucleus run trajectory
% current_simulation.show_torque_map           % show the torque map (if calculated)
% current_simulation.show_state_history        % show the history of states
% current_simulation.show_division_plane       % show predicted daughters according to the spindle position

% You can manipulate the state of the nucleus and spindle orientation, if needed:
% current_simulation.current_cell.x = 10       % to change the state of the nucleus
% current_simulation.current_cell.y = 20       % to change the state of the nucleus
% current_simulation.current_cell.z = 30       % to change the state of the nucleus
% current_simulation.current_cell.theta = 0    % to change spindle orientation
% current_simulation.current_cell.phi = 45     % to change spindle orientation

% current_simulation.get_new_names                      % generate new name for the simulatoin
% current_simulation.save_simulation_state              % save current state of the simulation (under new name is recommended)
% current_simulation.run                                % run simulations from this state

% current_simulation.current_cell.cell_path = 'C:\Data\new folder\cell_1\'      % reset the path to the cell
% current_simulation.save_simulation_state                                      % save current state of the simulation


